﻿using Percent___Qualification_work.Classes;
using System;
using System.Data;
using System.Numerics;
using System.Windows.Forms;
using static Percent___Qualification_work.userControls.planList;

namespace Percent___Qualification_work.userControls
{
    public partial class EditPlanControl : UserControl
    {

        public event EventHandler PlanUpdated;
        public int planId;

        public EditPlanControl()
        {
            InitializeComponent();
            priority.DropDownStyle = ComboBoxStyle.DropDownList;
        }

        public class ComboBoxItem
        {
            public string Text { get; set; }
            public int Value { get; set; }
            public override string ToString()
            {
                return Text; // Display the text in the ComboBox
            }
        }

        private void PopulateCombo()
        {
            priority.Items.Add(new ComboBoxItem { Text = "Low", Value = 1 });
            priority.Items.Add(new ComboBoxItem { Text = "Medium", Value = 2 });
            priority.Items.Add(new ComboBoxItem { Text = "High", Value = 3 });
        }

        private void LoadPlanDetails()
        {
            DataTable planTable = DatabaseConnection.Instance.GetPlanByID(planId);
            if (planTable.Rows.Count > 0)
            {
                DataRow plan = planTable.Rows[0];
                planName.Text = plan["name"].ToString();
                datePicker1.Value = DateTime.Parse(plan["date"].ToString());
                int priorityValue = Convert.ToInt32(plan["priority"]);
                foreach (ComboBoxItem item in priority.Items)
                {
                    if (item.Value == priorityValue)
                    {
                        priority.SelectedItem = item;
                        break;
                    }
                }
            }
        }

        public void InitializeEditPlanControl(int planId)
        {
            this.planId = planId;
            PopulateCombo();
            LoadPlanDetails();
        }

        private void saveBtn_Click(object sender, EventArgs e)
        {
            string name = planName.Text;
            string date = datePicker1.Value.ToString("yyyy-MM-dd");
            var planPriority = priority.SelectedItem as ComboBoxItem;

            if (!string.IsNullOrEmpty(name) && !string.IsNullOrEmpty(date) && priority != null)
            {
                DatabaseConnection.Instance.UpdatePlan(planId, name, date, planPriority.Value);
                MessageBox.Show("Plan updated successfully!");
                PlanUpdated?.Invoke(this, EventArgs.Empty);
                this.Visible = false;
            }
            else
            {
                MessageBox.Show("Please fill in all the fields!");
            }
        }

        private void EditPlanControl_Load(object sender, EventArgs e)
        {
            // Ensure that this method is not calling LoadPlanDetails
            // since InitializeEditPlanControl should handle it
        }

        private void backButton_Click(object sender, EventArgs e)
        {
            this.Visible = false;
        }
    }
}
